/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.nbt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class NBTLeavesFixer {
    public static void main(String[] args) {
        RuleSet ruleSet = new RuleSet();
        ruleSet.put("persistent", new Rule("true", "false"));
        String path = "H:\\Projects\\TerraForged\\TerraForgedMod\\src\\main\\resources\\data\\terraforged\\structures\\trees";
        NBTLeavesFixer.visit(new File(path), ruleSet);
    }

    public static void visit(File file, RuleSet ruleSet) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                NBTLeavesFixer.visit(f, ruleSet);
            }
        } else if (file.getName().endsWith(".nbt")) {
            try {
                INBT result;
                System.out.println("Opening file: " + file);
                try (FileInputStream in = new FileInputStream(file);){
                    CompoundNBT value = CompressedStreamTools.func_74796_a((InputStream)in);
                    result = NBTLeavesFixer.modify("", (INBT)value, ruleSet);
                    if (value == result) {
                        return;
                    }
                }
                System.out.println("Writing file: " + file);
                var5_10 = null;
                try (FileOutputStream out = new FileOutputStream(file);){
                    CompressedStreamTools.func_74799_a((CompoundNBT)((CompoundNBT)result), (OutputStream)out);
                }
                catch (Throwable throwable) {
                    var5_10 = throwable;
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static INBT modify(String name, INBT nbt, RuleSet ruleSet) {
        String value;
        if (nbt instanceof CompoundNBT) {
            CompoundNBT map = (CompoundNBT)nbt;
            boolean change = false;
            for (String key : map.func_150296_c()) {
                INBT value2 = map.func_74781_a(key);
                INBT result = NBTLeavesFixer.modify(key, value2, ruleSet);
                map.func_218657_a(key, result);
                change |= value2 != result;
            }
            return change ? map.func_74737_b() : map;
        }
        if (nbt instanceof ListNBT) {
            ListNBT list = (ListNBT)nbt;
            boolean change = false;
            for (int i = 0; i < list.size(); ++i) {
                INBT value3 = list.get(i);
                INBT result = NBTLeavesFixer.modify(name + "[" + i + "]", value3, ruleSet);
                list.set(i, result);
                change |= result != value3;
            }
            return change ? list.func_74737_b() : list;
        }
        Rule rule = (Rule)ruleSet.get(name);
        if (rule == null) {
            return nbt;
        }
        if (nbt instanceof StringNBT && (value = nbt.func_150285_a_()).equals(rule.match)) {
            System.out.println(" Replaced value for: " + name);
            return StringNBT.func_229705_a_((String)rule.replace.toString());
        }
        return nbt;
    }

    private static class Rule {
        private final Object match;
        private final Object replace;

        private Rule(Object match, Object replace) {
            this.match = match;
            this.replace = replace;
        }
    }

    private static class RuleSet
    extends HashMap<String, Rule> {
        private RuleSet() {
        }
    }
}

